@echo off
chcp 65001 > nul
title 帆船AmongUs服务器安装器

:: 设置颜色
for /f "delims=#" %%a in ('"prompt #$E# & for %%a in (1) do rem"') do set "ESC=%%a"
set "GREEN=%ESC%[92m"
set "YELLOW=%ESC%[93m"
set "CYAN=%ESC%[96m"
set "RED=%ESC%[91m"
set "BLUE=%ESC%[94m"
set "MAGENTA=%ESC%[95m"
set "ORANGE=%ESC%[38;5;214m"
set "PURPLE=%ESC%[38;5;129m"
set "GOLD=%ESC%[38;5;220m"
set "RESET=%ESC%[0m"

:: 隐藏光标
echo %ESC%[?25l

:: 显示启动画面
call :startup_screen

:: 初始化界面
call :loading_screen "正在初始化系统" 3

:: 检查依赖项界面
call :loading_screen "正在检查依赖项" 3

:: 检查系统版本界面
call :loading_screen "正在检查系统版本" 3

:: 显示主菜单
:main_menu
cls
echo.
echo.
echo    %GREEN%╔══════════════════════════════════════════════════╗%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%          %CYAN%帆船AmongUs服务器安装器%RESET%           %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%               %YELLOW%主菜单%RESET%                    %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%╚══════════════════════════════════════════════════╝%RESET%
echo.
echo.
echo        %BLUE%[1]%RESET% 安装帆船AmongUs服务器
echo.
echo        %BLUE%[2]%RESET% 联系服主
echo.
echo        %BLUE%[3]%RESET% 跳转官网
echo.
echo        %BLUE%[4]%RESET% 关于
echo.
echo        %RED%[5]%RESET% 退出
echo.
echo.
set /p "choice=        请选择 [1-5]: "

if "%choice%"=="1" (
    goto :install_menu
) else if "%choice%"=="2" (
    goto :contact_owner
) else if "%choice%"=="3" (
    goto :open_website
) else if "%choice%"=="4" (
    goto :about
) else if "%choice%"=="5" (
    goto :exit_program
) else (
    echo.
    echo        %RED%无效选择，请重新输入%RESET%
    timeout /t 2 > nul
    goto :main_menu
)

:: 安装方式选择菜单
:install_menu
cls
echo.
echo.
echo    %GREEN%╔══════════════════════════════════════════════════╗%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%          %CYAN%帆船AmongUs服务器安装器%RESET%           %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%           %YELLOW%请选择安装方式:%RESET%                 %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%╚══════════════════════════════════════════════════╝%RESET%
echo.
echo.
echo        %BLUE%[1] 在线安装%RESET% - 从服务器下载最新配置文件
echo.
echo        %BLUE%[2] 离线安装%RESET% - 使用内置配置文件
echo.
echo        %BLUE%[0] 返回主菜单%RESET%
echo.
echo.
set /p "choice=        请选择 [0-2]: "

if "%choice%"=="1" (
    goto :online_install
) else if "%choice%"=="2" (
    goto :offline_install
) else if "%choice%"=="0" (
    goto :main_menu
) else (
    echo.
    echo        %RED%无效选择，请重新输入%RESET%
    timeout /t 2 > nul
    goto :install_menu
)

:: 联系服主
:contact_owner
cls
call :loading_screen "正在联系服主" 2
start "" "https://qm.qq.com/q/nm4yfCdaWQ"
echo %ESC%[?25h
exit /b 0

:: 跳转官网
:open_website
cls
call :loading_screen "正在跳转官网" 2
start "" "https://au.fanchuanovo.cn"
echo %ESC%[?25h
exit /b 0

:: 关于页面
:about
cls
echo.
echo.
echo    %GREEN%╔══════════════════════════════════════════════════╗%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%          %CYAN%帆船AmongUs服务器安装器%RESET%           %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%                %YELLOW%关于%RESET%                     %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%╚══════════════════════════════════════════════════╝%RESET%
echo.
echo.
echo        %CYAN%制作：帆船%RESET%
echo.
echo        %CYAN%帆船AmongUs服务器版权所有%RESET%
echo.
echo        %CYAN%当前版本:test1.0%RESET%
echo.
echo        %CYAN%如遇问题请返回主菜单选择联系服主进行反馈。%RESET%
echo.
echo.
echo        %YELLOW%按任意键返回主菜单...%RESET%
echo.
pause > nul
goto :main_menu

:: 在线安装
:online_install
cls
echo.
echo.
echo    %GREEN%╔══════════════════════════════════════════════════╗%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%          %CYAN%帆船AmongUs服务器安装器%RESET%           %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%            %YELLOW%在线安装中...%RESET%                 %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%╚══════════════════════════════════════════════════╝%RESET%
echo.

:: 创建C盘文件夹
call :spinner_with_text "正在创建文件夹" 1
if not exist "C:\fanchuanauserver" (
    mkdir "C:\fanchuanauserver" >nul 2>&1
    if errorlevel 1 (
        echo        %RED%无法创建文件夹，请以管理员身份运行%RESET%
        goto :error
    )
)

:: 下载JSON文件
call :spinner_with_text "正在下载配置文件" 2
powershell -Command "Invoke-WebRequest -Uri 'https://au.fanchuanovo.cn/wp-content/uploads/2025/10/regionInfo.json' -OutFile 'C:\fanchuanauserver\regionInfo.json'" >nul 2>&1
if errorlevel 1 (
    echo        %RED%下载失败，切换到离线安装模式...%RESET%
    timeout /t 2 >nul
    goto :offline_install
)

:: 复制文件到游戏目录
call :copy_to_game

:: 创建菜单文件
call :create_menu_file

:: 完成界面
goto :install_complete

:: 离线安装
:offline_install
cls
echo.
echo.
echo    %GREEN%╔══════════════════════════════════════════════════╗%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%          %CYAN%帆船AmongUs服务器安装器%RESET%           %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%            %YELLOW%离线安装中...%RESET%                 %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%╚══════════════════════════════════════════════════╝%RESET%
echo.

:: 创建C盘文件夹并保存离线版本
call :spinner_with_text "正在创建文件夹" 1
if not exist "C:\fanchuanauserver" (
    mkdir "C:\fanchuanauserver" >nul 2>&1
)

:: 写入JSON内容到C盘
call :spinner_with_text "正在生成配置文件" 2
(
echo {
echo 	"CurrentRegionIdx": 5,
echo   	"Regions": [
echo         {
echo             "$type":"StaticHttpRegionInfo, Assembly-CSharp",
echo             "Name":"<color=#ff7518>\u5e06\u8239\u670d</color><color=#ffff00>[\u5e7f\u5dde]</color>",
echo             "PingServer":"gz.fcaugame.cn",
echo             "Servers":[
echo                 {
echo                     "Name":"http-1",
echo                     "Ip":"gz.fcaugame.cn",
echo                     "Port":443,
echo                     "UseDtls":false,
echo                     "Players":0,
echo                     "ConnectionFailures":0
echo                 }
echo             ],
echo             "TargetServer":null,
echo             "TranslateName":1003
echo         }
echo     ]
echo }
) > "C:\fanchuanauserver\regionInfo.json"

:: 复制文件到游戏目录
call :copy_to_game

:: 创建菜单文件
call :create_menu_file

:: 完成界面
:install_complete
cls
echo.
echo.
echo    %GREEN%╔══════════════════════════════════════════════════╗%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%          %CYAN%帆船AmongUs服务器安装器%RESET%           %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%              %GREEN%安装完成！%RESET%                   %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%╚══════════════════════════════════════════════════╝%RESET%
echo.
echo        %YELLOW%帆船AmongUs服务器已成功安装！%RESET%
echo.
echo        %CYAN%按任意键返回主菜单...%RESET%
echo.
pause > nul
goto :main_menu

:: 复制文件到游戏目录
:copy_to_game
:: 获取APPDATA路径
for /f "tokens=*" %%i in ('echo %APPDATA%') do set APPDATA_PATH=%%i

:: 构建目标文件路径
set TARGET_PATH=%APPDATA_PATH%\..\LocalLow\Innersloth\Among Us\regionInfo.json

:: 创建目录（如果不存在）
set TARGET_DIR=%APPDATA_PATH%\..\LocalLow\Innersloth\Among Us
call :spinner_with_text "正在创建游戏目录" 1
if not exist "%TARGET_DIR%" (
    mkdir "%TARGET_DIR%" >nul 2>&1
    if errorlevel 1 (
        echo        %RED%无法创建游戏目录，请以管理员身份运行%RESET%
        goto :error
    )
)

:: 复制文件
call :spinner_with_text "正在复制文件到游戏目录" 2
copy "C:\fanchuanauserver\regionInfo.json" "%TARGET_PATH%" >nul 2>&1
if errorlevel 1 (
    echo        %RED%复制文件失败%RESET%
    goto :error
)

echo        %GREEN%文件复制成功！%RESET%
timeout /t 2 > nul
goto :eof

:: 创建菜单文件
:create_menu_file
call :spinner_with_text "正在创建菜单文件" 1
(
echo 111001101000000110101101111001011001011010011100111001001011110110100000111001011000111110010001111001111000111010110000111001001011101010000110111001011011100010000110111010001000100010111001111001101001110010001101111001101010110110100011111001111000100110001000111001011010111010001001111010001010001110000101111001011001100110101000111001111001101010000100111010011001100010110010111001001011110010101010111001011011110110101001111010001001101110001011111011111011110010001100111001001011110110000110111001101001100010101111111001101011001010100001111001101001110010001001111001011010010110010110111001011000101010110001111011111011110010011010111011111011110010001001
) > "C:\fanchuanauserver\caidan.txt"
echo        %GREEN%菜单文件创建成功！%RESET%
timeout /t 1 > nul
goto :eof

:: 启动画面
:startup_screen
cls
echo.
echo.
echo    %MAGENTA%███████╗ █████╗ ███╗   ██╗ ██████╗██╗  ██╗██╗   ██╗ █████╗ ███╗   ██╗%RESET%
echo    %CYAN%██╔════╝██╔══██╗████╗  ██║██╔════╝██║  ██║██║   ██║██╔══██╗████╗  ██║%RESET%
echo    %GREEN%█████╗  ███████║██╔██╗ ██║██║     ███████║██║   ██║███████║██╔██╗ ██║%RESET%
echo    %YELLOW%██╔══╝  ██╔══██║██║╚██╗██║██║     ██╔══██║██║   ██║██╔══██║██║╚██╗██║%RESET%
echo    %RED%██║     ██║  ██║██║ ╚████║╚██████╗██║  ██║╚██████╔╝██║  ██║██║ ╚████║%RESET%
echo    %ORANGE%╚═╝     ╚═╝  ╚═╝╚═╝  ╚═══╝ ╚═════╝╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═╝╚═╝  ╚═══╝%RESET%
echo.
echo    %PURPLE%╔══════════════════════════════════════════════════╗%RESET%
echo    %PURPLE%║%RESET%                                                  %PURPLE%║%RESET%
echo    %PURPLE%║%RESET%           %GOLD%帆船AmongUs服务器安装器%RESET%           %PURPLE%║%RESET%
echo    %PURPLE%║%RESET%                                                  %PURPLE%║%RESET%
echo    %PURPLE%╚══════════════════════════════════════════════════╝%RESET%
echo.
echo        %CYAN%正在启动，请稍候...%RESET%
echo.
call :spinner 3
goto :eof

:: 加载屏幕（带旋转动画）
:loading_screen
setlocal
set "text=%~1"
set /a "duration=%~2"

cls
echo.
echo.
echo    %GREEN%╔══════════════════════════════════════════════════╗%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%          %CYAN%帆船AmongUs服务器安装器%RESET%           %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%            %YELLOW%%text%%...%RESET%                     %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%╚══════════════════════════════════════════════════╝%RESET%
echo.
echo.
call :spinner_with_text "%text%" %duration%
echo.
endlocal
goto :eof

:: 带文字的旋转动画函数
:spinner_with_text
setlocal
set "text=%~1"
set /a "duration=%~2"
set "frames=⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏"
set "frame_count=10"
set /a "total_loops=duration*5"

for /l %%i in (1,1,%total_loops%) do (
    set /a "frame_index=%%i %% frame_count"
    for %%j in (!frame_index!) do (
        <nul set /p "=%CYAN%!frames:~%%j,1!%RESET% %YELLOW%%text%...%RESET%"
    )
    ping -n 1 -w 200 127.0.0.1 > nul
    <nul set /p "=%ESC%[2K%ESC%[0G"
)
echo        %GREEN%✓%RESET% %YELLOW%%text%完成%RESET%
endlocal
goto :eof

:: 旋转动画函数
:spinner
setlocal
set /a "duration=%~1"
set "frames=⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏"
set "frame_count=10"
set /a "total_loops=duration*5"

for /l %%i in (1,1,%total_loops%) do (
    set /a "frame_index=%%i %% frame_count"
    for %%j in (!frame_index!) do (
        <nul set /p "=%YELLOW%!frames:~%%j,1!%RESET% %CYAN%"
    )
    ping -n 1 -w 200 127.0.0.1 > nul
    <nul set /p "=%ESC%[2D"
)
echo %RESET%   
endlocal
goto :eof

:: 退出程序
:exit_program
cls
echo.
echo.
echo    %GREEN%╔══════════════════════════════════════════════════╗%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%          %CYAN%帆船AmongUs服务器安装器%RESET%           %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%║%RESET%              %YELLOW%感谢使用！%RESET%                   %GREEN%║%RESET%
echo    %GREEN%║%RESET%                                                  %GREEN%║%RESET%
echo    %GREEN%╚══════════════════════════════════════════════════╝%RESET%
echo.
echo        %CYAN%程序即将退出...%RESET%
echo.
call :spinner 2
echo %ESC%[?25h
exit /b 0

:: 错误处理
:error
echo.
echo        %RED%安装失败！%RESET%
echo.
echo        %YELLOW%可能的解决方案:%RESET%
echo        %CYAN%1. 以管理员身份运行此程序%RESET%
echo        %CYAN%2. 关闭Among Us游戏和其他可能使用此文件的程序%RESET%
echo        %CYAN%3. 检查网络连接（在线安装）%RESET%
echo.
echo        %CYAN%按任意键返回主菜单...%RESET%
echo %ESC%[?25h
pause > nul
goto :main_menu