@echo off
chcp 65001 > nul
title 帆船AmongUs服务器安装器

:: 设置颜色
for /f "delims=#" %%a in ('"prompt #$E# & for %%a in (1) do rem"') do set "ESC=%%a"
set "GREEN=%ESC%[92m"
set "YELLOW=%ESC%[93m"
set "CYAN=%ESC%[96m"
set "RED=%ESC%[91m"
set "BLUE=%ESC%[94m"
set "MAGENTA=%ESC%[95m"
set "ORANGE=%ESC%[38;5;214m"
set "PURPLE=%ESC%[38;5;129m"
set "GOLD=%ESC%[38;5;220m"
set "RESET=%ESC%[0m"

:: 隐藏光标
echo %ESC%[?25l

:: 确保C盘文件夹存在
if not exist "C:\fanchuanauserver" (
    mkdir "C:\fanchuanauserver" >nul 2>&1
)

:: 显示启动画面
call :startup_screen

:: 初始化界面
call :loading_screen "正在初始化系统" 3

:: 检查依赖项界面
call :loading_screen "正在检查依赖项" 3

:: 检查系统版本界面
call :loading_screen "正在检查系统版本" 3

:: 显示主菜单
:main_menu
call :display_header "主菜单"
echo.
echo        %BLUE%[1]%RESET% 安装帆船AmongUs服务器
echo.
echo        %BLUE%[2]%RESET% 修复旧版游戏
echo.
echo        %BLUE%[3]%RESET% 联系服主
echo.
echo        %BLUE%[4]%RESET% 跳转官网
echo.
echo        %BLUE%[5]%RESET% 关于
echo.
echo        %RED%[6]%RESET% 退出
echo.
echo.
set /p "choice=        请选择 [1-6]: "

if "%choice%"=="1" (
    goto :install_menu
) else if "%choice%"=="2" (
    goto :repair_old_version
) else if "%choice%"=="3" (
    goto :contact_owner
) else if "%choice%"=="4" (
    goto :open_website
) else if "%choice%"=="5" (
    goto :about
) else if "%choice%"=="6" (
    goto :exit_program
) else (
    echo.
    echo        %RED%无效选择，请重新输入%RESET%
    timeout /t 2 > nul
    goto :main_menu
)

:: 安装方式选择菜单
:install_menu
call :display_header "请选择安装方式"
echo.
echo        %BLUE%[1] 在线安装%RESET% - 从服务器下载最新配置文件
echo.
echo        %BLUE%[2] 离线安装%RESET% - 使用内置配置文件
echo.
echo        %BLUE%[0] 返回主菜单%RESET%
echo.
echo.
set /p "choice=        请选择 [0-2]: "

if "%choice%"=="1" (
    goto :online_install
) else if "%choice%"=="2" (
    goto :offline_install
) else if "%choice%"=="0" (
    goto :main_menu
) else (
    echo.
    echo        %RED%无效选择，请重新输入%RESET%
    timeout /t 2 > nul
    goto :install_menu
)

:: 修复旧版游戏功能
:repair_old_version
call :display_header "修复旧版游戏"
echo.
echo        %CYAN%代码来源：沫夏悠轩，搬运到本安装器：帆船%RESET%
echo.
echo        %YELLOW%用于解决打开新版游戏后旧版游戏黑屏的问题%RESET%
echo.
echo        %CYAN%准备下载旧版本游戏设置%RESET%
echo.
echo.
echo        %YELLOW%请按任何按键确认执行，否则请关闭脚本。%RESET%
echo.
pause > nul
cls
call :display_header "修复旧版游戏"
echo.
echo        %CYAN%正在下载旧版本游戏设置...%RESET%
echo.
curl "http://api.mxyx.club/download/among-us/OtherFiles/settings.amogus" -o "%AppData%\..\LocalLow\Innersloth\Among Us\settings.amogus"
IF %ERRORLEVEL% NEQ 0 (
    echo        %RED%下载失败%RESET%
    pause > nul
    goto :main_menu
)
echo.
echo        %GREEN%成功修复旧版游戏设置！%RESET%
echo.
:: 创建菜单文件
call :create_menu_file
echo.
echo        %YELLOW%按任意键返回主菜单...%RESET%
echo.
pause > nul
goto :main_menu

:: 联系服主
:contact_owner
call :loading_screen "正在联系服主" 2
start "" "https://qm.qq.com/q/nm4yfCdaWQ"
echo %ESC%[?25h
exit /b 0

:: 跳转官网
:open_website
call :loading_screen "正在跳转官网" 2
start "" "https://au.fanchuanovo.cn"
echo %ESC%[?25h
exit /b 0

:: 关于页面
:about
call :display_header "关于"
echo.
echo        %CYAN%制作：帆船%RESET%
echo.
echo        %CYAN%当前版本：v2.1测试多功能首次官方发行版%RESET%
echo.
echo        %CYAN%©帆船AmongUs服务器 版权所有%RESET%
echo.
echo        %YELLOW%按任意键返回主菜单...%RESET%
echo.
pause > nul
goto :main_menu

:: 在线安装
:online_install
call :display_header "在线安装中"
echo.

:: 创建C盘文件夹
call :spinner_with_text "正在创建文件夹" 1
if not exist "C:\fanchuanauserver" (
    mkdir "C:\fanchuanauserver" >nul 2>&1
    if errorlevel 1 (
        echo        %RED%无法创建文件夹，请以管理员身份运行%RESET%
        goto :error
    )
)

:: 下载JSON文件
call :spinner_with_text "正在连接到安装源服务器下载配置文件..." 2
powershell -Command "Invoke-WebRequest -Uri 'https://au.fanchuanovo.cn/wp-content/uploads/2025/10/regionInfo.json' -OutFile 'C:\fanchuanauserver\regionInfo.json'" >nul 2>&1
if errorlevel 1 (
    echo        %RED%下载失败，切换到离线安装模式...%RESET%
    timeout /t 2 >nul
    goto :offline_install
)

:: 复制文件到游戏目录
call :copy_to_game

:: 创建菜单文件
call :create_menu_file

:: 完成界面
goto :install_complete

:: 离线安装
:offline_install
call :display_header "离线安装中"
echo.

:: 创建C盘文件夹并保存离线版本
call :spinner_with_text "正在创建文件夹" 1
if not exist "C:\fanchuanauserver" (
    mkdir "C:\fanchuanauserver" >nul 2>&1
)

:: 写入JSON内容到C盘
call :spinner_with_text "正在调用内置配置文件" 2
(
echo {
echo 	"CurrentRegionIdx": 5,
echo   	"Regions": [
echo         {
echo             "$type":"StaticHttpRegionInfo, Assembly-CSharp",
echo             "Name":"<color=#ff7518>\u5e06\u8239\u670d</color><color=#ffff00>[\u5e7f\u5dde]</color>",
echo             "PingServer":"gz.fcaugame.cn",
echo             "Servers":[
echo                 {
echo                     "Name":"http-1",
echo                     "Ip":"gz.fcaugame.cn",
echo                     "Port":443,
echo                     "UseDtls":false,
echo                     "Players":0,
echo                     "ConnectionFailures":0
echo                 }
echo             ],
echo             "TargetServer":null,
echo             "TranslateName":1003
echo         }
echo     ]
echo }
) > "C:\fanchuanauserver\regionInfo.json"

:: 复制文件到游戏目录
call :copy_to_game

:: 创建菜单文件
call :create_menu_file

:: 完成界面
:install_complete
call :display_header "安装完成"
echo.
echo        %YELLOW%帆船AmongUs服务器已成功安装！%RESET%
echo.
echo        %CYAN%按任意键返回主菜单...%RESET%
echo.
pause > nul
goto :main_menu

:: 复制文件到游戏目录
:copy_to_game
:: 获取APPDATA路径
for /f "tokens=*" %%i in ('echo %APPDATA%') do set APPDATA_PATH=%%i

:: 构建目标文件路径
set TARGET_PATH=%APPDATA_PATH%\..\LocalLow\Innersloth\Among Us\regionInfo.json

:: 创建目录（如果不存在）
set TARGET_DIR=%APPDATA_PATH%\..\LocalLow\Innersloth\Among Us
call :spinner_with_text "正在创建游戏目录" 1
if not exist "%TARGET_DIR%" (
    mkdir "%TARGET_DIR%" >nul 2>&1
    if errorlevel 1 (
        echo        %RED%无法创建游戏目录，请以管理员身份运行%RESET%
        goto :error
    )
)

:: 复制文件
call :spinner_with_text "正在复制文件到游戏目录" 2
copy "C:\fanchuanauserver\regionInfo.json" "%TARGET_PATH%" >nul 2>&1
if errorlevel 1 (
    echo        %RED%复制文件失败%RESET%
    goto :error
)

echo        %GREEN%文件复制成功！%RESET%
timeout /t 2 > nul
goto :eof

:: 创建菜单文件
:create_menu_file
call :spinner_with_text "正在创建菜单文件" 1
:: 如果文件已存在，则删除
if exist "C:\fanchuanauserver\caidan.txt" (
    del "C:\fanchuanauserver\caidan.txt" >nul 2>&1
)
(
echo 11100110100000011010110111100101100101101001110011100100101111011010000011100101100011111001000111100111100011101011000011100100101110101000011011100101101110001000011011101000100010001011100111100110100111001000110111100110101011011010001111100111100010011000100011100101101011101000100111101000101000111000010111100101100110011010100011100111100110101000010011101001100110001011001011100100101111001010101011100101101111011010100111101000100110111000101111101111101111001000110011100100101111011000011011100110100110001010111111100110101100101010000111100110100111001000100111100101101001011001011011100101100010101011000111101111101111001001101011101111101111001000100111101111101111001000110011100101101111011001001111100101100010011000110111100111100010011000100011100110100111001010110000110010001011100011000111100110101101011000101111101000101011111001010101110100011001010111001101110100111001011010010010011010111001011000101010011111111010001000001110111101111010011010011010010110111001101010110010100001111001011000111110010001111010001010000110001100111001111000100110001000
) > "C:\fanchuanauserver\caidan.txt"
echo        %GREEN%菜单文件创建成功！%RESET%
timeout /t 1 > nul
goto :eof

:: 启动画面
:startup_screen
cls
echo.
echo.
echo    %MAGENTA%███████╗ █████╗ ███╗   ██╗ ██████╗██╗  ██╗██╗   ██╗ █████╗ ███╗   ██╗%RESET%
echo    %CYAN%██╔════╝██╔══██╗████╗  ██║██╔════╝██║  ██║██║   ██║██╔══██╗████╗  ██║%RESET%
echo    %GREEN%█████╗  ███████║██╔██╗ ██║██║     ███████║██║   ██║███████║██╔██╗ ██║%RESET%
echo    %YELLOW%██╔══╝  ██╔══██║██║╚██╗██║██║     ██╔══██║██║   ██║██╔══██║██║╚██╗██║%RESET%
echo    %RED%██║     ██║  ██║██║ ╚████║╚██████╗██║  ██║╚██████╔╝██║  ██║██║ ╚████║%RESET%
echo    %ORANGE%╚═╝     ╚═╝  ╚═╝╚═╝  ╚═══╝ ╚═════╝╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═╝╚═╝  ╚═══╝%RESET%
echo.
echo        %CYAN%正在启动，请稍候...%RESET%
echo.
call :spinner 3
goto :eof

:: 显示标题头
:display_header
setlocal
set "step_name=%~1"
cls
echo.
echo    %MAGENTA%=============================================%RESET%
echo    %CYAN%         丨%GREEN%帆船%YELLOW%AmongUs%RED%服务器%BLUE%工具箱%PURPLE%丨%RESET%
echo    %MAGENTA%=============================================%RESET%
echo    %GOLD%           %step_name%%RESET%
echo.
endlocal
goto :eof

:: 加载屏幕（带旋转动画）
:loading_screen
setlocal
set "text=%~1"
set /a "duration=%~2"

call :display_header "%text%"
echo.
call :spinner_with_text "%text%" %duration%
echo.
endlocal
goto :eof

:: 带文字的旋转动画函数
:spinner_with_text
setlocal
set "text=%~1"
set /a "duration=%~2"
set "frames=⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏"
set "frame_count=10"
set /a "total_loops=duration*5"

for /l %%i in (1,1,%total_loops%) do (
    set /a "frame_index=%%i %% frame_count"
    for %%j in (!frame_index!) do (
        <nul set /p "=%CYAN%!frames:~%%j,1!%RESET% %YELLOW%%text%...%RESET%"
    )
    ping -n 1 -w 200 127.0.0.1 > nul
    <nul set /p "=%ESC%[2K%ESC%[0G"
)
echo        %GREEN%✓%RESET% %YELLOW%%text%完成%RESET%
endlocal
goto :eof

:: 旋转动画函数
:spinner
setlocal
set /a "duration=%~1"
set "frames=⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏"
set "frame_count=10"
set /a "total_loops=duration*5"

for /l %%i in (1,1,%total_loops%) do (
    set /a "frame_index=%%i %% frame_count"
    for %%j in (!frame_index!) do (
        <nul set /p "=%YELLOW%!frames:~%%j,1!%RESET% %CYAN%"
    )
    ping -n 1 -w 200 127.0.0.1 > nul
    <nul set /p "=%ESC%[2D"
)
echo %RESET%   
endlocal
goto :eof

:: 退出程序
:exit_program
call :display_header "感谢使用"
echo.
echo        %CYAN%程序即将退出...%RESET%
echo.
call :spinner 2
echo %ESC%[?25h
exit /b 0

:: 错误处理
:error
echo.
echo        %RED%安装失败！%RESET%
echo.
echo        %YELLOW%可能的解决方案:%RESET%
echo        %CYAN%1. 以管理员身份运行此程序%RESET%
echo        %CYAN%2. 关闭Among Us游戏和其他可能使用此文件的程序%RESET%
echo        %CYAN%3. 检查网络连接（在线安装）%RESET%
echo.
echo        %CYAN%按任意键返回主菜单...%RESET%
echo %ESC%[?25h
pause > nul
goto :main_menu